﻿using System;
using System.Collections.Generic;
using System.Linq;

using VIRP.CRS.BLL;
using VIRP.CRS.BO;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;

namespace VIRP_WEB.Custom.EFR
{
    public class InterpretationBasePage : EfrBasePage
    {
        protected WKF_CASE_ACTIVITY GetInterpretationActivity(WKF_CASE wCase)
        {
            return WKF_CASE_ACTIVITYManager.GetitemsByWorkflowCaseId(CurrentUser, CurrentRegistryId, wCase.WKF_CASE_ID)
                .Where(a => a.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation) && a.ARCHIVED_FLAG == false)
                .FirstOrDefault();
        }

        protected WKF_CASE_ACTIVITY GetLabResult(WKF_CASE wCase)
        {
            return WKF_CASE_ACTIVITYManager.GetitemsByWorkflowCaseId(CurrentUser, CurrentRegistryId, wCase.WKF_CASE_ID)
                .Where(a => a.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.LabResult)
                    && a.STD_WKFACTIVITYSTS_ID == Convert.ToInt16(WorkflowCaseActivityStatus.Accepted)
                    && a.ARCHIVED_FLAG == false)
                .FirstOrDefault();
        }

        protected WKF_CASE_ACTIVITY GetLabOrder(WKF_CASE wCase)
        {
            return WKF_CASE_ACTIVITYManager.GetitemsByWorkflowCaseId(CurrentUser, CurrentRegistryId, wCase.WKF_CASE_ID)
                .Where(a => a.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.LabOrder)
                    && a.ARCHIVED_FLAG == false)
                .FirstOrDefault();
        }

        protected void OpenCloseReferralAndWorkflowCase(Func<string> operation, WKF_CASE wCase, string patientIcn)
        {
            var referral = VIRP.CRS.BLL.REFERRALManager.GetItem(CurrentUser, CurrentRegistryId, wCase.REFERRAL_ID.Value);
            var allCases = VIRP.CRS.BLL.WKF_CASEManager.GetItemsByReferral(CurrentUser, CurrentRegistryId, referral.REFERRAL_ID);

            if (operation() == "Interpret")
            {
                wCase.STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.Completed;

                var items = allCases.Except(new List<WKF_CASE> { wCase }, new WorkflowCaseComparer());
                if (items.Count(a => a.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.Completed) == 0)
                    referral.STD_REFERRALSTS_ID = (int)ReferralStatus.Completed;
            }
            else
            {
                if (referral.STD_REFERRALSTS_ID != (int)ReferralStatus.InProcess)
                    referral.STD_REFERRALSTS_ID = (int)ReferralStatus.InProcess;

                if (wCase.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.InProcess)
                {
                    wCase.STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.InProcess;
                    VIRP.CRS.BLL.WKF_CASEManager.Save(CurrentUser, CurrentRegistryId, wCase);
                } 
            }

            VIRP.CRS.BLL.REFERRALManager.Save(CurrentUser, CurrentRegistryId, referral);
        }

        protected CONTACT_LOG CreateNewContact(PatientDetails patientDetails, int referralId)
        {
            const string CONTACT_MESSAGE_BASE = "Interpretation Letter was printed by {0}.  The interpretation letter was sent to both the patient indicated above, and the provider as indicated on the interpretation screen.";

            CONTACT_LOG contact = new CONTACT_LOG();

            contact.REFERRAL_ID = referralId;
            contact.CONTACT_FIRST_NAME = patientDetails.FIRST_NAME;
            contact.CONTACT_LAST_NAME = patientDetails.LAST_NAME;
            contact.CONTACT_DATE = DateTime.Now;
            contact.CONTACT_METHOD_TEXT = "Mail";
            contact.CONTACT_EMAIL = null;
            contact.CONTACT_ADDR1 = patientDetails.ADDRESS_LINE1;
            contact.CONTACT_ADDR2 = patientDetails.ADDRESS_LINE2;
            contact.CONTACT_ADDR3 = patientDetails.ADDRESS_LINE3;
            contact.CONTACT_CITY = patientDetails.CITY;
            contact.CONTACT_STATE = patientDetails.STATE;
            contact.CONTACT_POSTAL = patientDetails.POSTAL_CODE;
            contact.CONTACT_ZIPPLUS4 = patientDetails.ZIP_PLUS_4;
            contact.CONTACT_COUNTRY = patientDetails.COUNTRY;
            contact.CONTACT_REASON_TEXT = "Interpretation Letter Printed";
            contact.TELEMEDICINE_PATIENT_FLAG = false;
            contact.TELEMEDICINE_PROVIDER_FLAG = false;
            contact.INPATIENT_EVAL_RECOM_FLAG = false;
            contact.CONTACT_MESSAGE_TEXT = string.Format(CONTACT_MESSAGE_BASE, CurrentUser);

            var id = CONTACT_LOGManager.Save(CurrentUser, CurrentRegistryId, contact);

            return CONTACT_LOGManager.GetItem(CurrentUser, CurrentRegistryId, id);
        }
    }
}